local toc, data = ...
local AddonId = toc.identifier

local statList = Inspect.Stat()
local mouseFrame = {}
local mouseFrameCreated = false
local toNum = tonumber

GCB = {}
GCB.Context = UI.CreateContext("gcbContext")
GCB.Context:SetStrata("modal")
GCB.display = {}

local function mouseUpdate(xcoord, ycoord)
	
	local function createMouseFrame()
		mouseFrame = UI.CreateFrame("Frame", "mouseFrame", GCB.Context)
			mouseFrame:SetHeight(22)
			mouseFrame:SetWidth(143)
			mouseFrame:SetBackgroundColor(1,1,1,1)
			mouseFrame:SetLayer(10)
			mouseFrame:SetVisible(false)
			
		mouseFrame.icon = UI.CreateFrame("Texture", "mouseFrame_icon", mouseFrame)
			mouseFrame.icon:SetPoint("CENTERLEFT", mouseFrame, "CENTERLEFT", 1, 0)
			mouseFrame.icon:SetBackgroundColor(0,0,0,1)
			mouseFrame.icon:SetHeight(20)
			mouseFrame.icon:SetWidth(20)
			mouseFrame.icon:SetLayer(20)
		
		mouseFrame.text = UI.CreateFrame("Text", AddonId .. "mouseFrame_text", mouseFrame)
			mouseFrame.text:SetPoint("CENTERLEFT", mouseFrame.icon, "CENTERRIGHT")
			mouseFrame.text:SetHeight(20)
			mouseFrame.text:SetWidth(121)
			mouseFrame.text:SetBackgroundColor(0,0,0,1)
			mouseFrame.text:SetFontColor(1,1,1,1)
			mouseFrame.text:SetFontSize(14)
			mouseFrame.text:SetLayer(20)
			
		mouseFrameCreated = true
	end
	
	if mouseFrameCreated == false then
		createMouseFrame()
	end
	
	if mouseFrame:GetVisible() then
		mouseFrame:SetPoint("CENTER", WT.Context, "CENTER", xcoord-18, ycoord-18)
	end
	
end

local function Coin(coin,returnNum)
	if not coin then return end

	local plat = 0
	local gold = 0
	local silver = 0
	local len = string.len(coin)
	
	if len < 5 then
		repeat
			coin = "0" .. coin
		until string.len(coin) == 5
		len = string.len(coin)
	end
	
	if coin == 0 or nil then
		return plat
	else
		plat = string.sub(coin,1,len-4)
		gold = string.sub(coin,len-3,len-2)
		silver = string.sub(coin,len-1,len)
		if returnNum == 1 then
			return plat
		elseif returnNum == 2 then
			return gold
		elseif returnNum == 3 then
			return silver
		else
			return 0
		end
	end
end

local function currencyUpdate(stats)

	if not GCB.display then return end

	for id, columns in pairs(GCB.display) do
		for name, num in pairs(stats) do
			for column, rows in ipairs(GCB.display[id].data) do
				for row, data in pairs(rows) do
					if name == data.name then
						data.stack:SetText(tostring(num))
					elseif name == "coin" and data.name == "platinum" then
						data.stack:SetText(tostring(Coin(num,1)))
					elseif name == "coin" and data.name == "gold" then
						data.stack:SetText(tostring(Coin(num,2)))
					elseif name == "coin" and data.name == "silver" then
						data.stack:SetText(tostring(Coin(num,3)))
					end
				end
			end
		end
	end
end

function GCB:PreviewCellConfig(cellInfo)

	if not GCB.cellConfig then
	
	Command.System.Watchdog.Quiet()
		
		GCB.cellConfig = UI.CreateFrame("Texture", AddonId .. "_cellConfig", GCB.container)
			GCB.cellConfig:SetPoint("CENTERLEFT", GCB.container, "CENTERRIGHT", 10, -40)
			GCB.cellConfig:SetHeight(450)
			GCB.cellConfig:SetWidth(300)
			GCB.cellConfig:SetTexture(AddonId, "img/midWindow.png")
			
		GCB.cellConfig.btnOK = UI.CreateFrame("RiftButton", AddonId .. "_cellConfig_OKbtn", GCB.cellConfig)
			GCB.cellConfig.btnOK:SetText("OK")
			GCB.cellConfig.btnOK:SetPoint("BOTTOMRIGHT", GCB.cellConfig, "BOTTOMCENTER", 0, -10)
			GCB.cellConfig.btnOK:SetEnabled(true)
			
		GCB.cellConfig.btnCancel = UI.CreateFrame("RiftButton", AddonId .. "_cellConfig_Cancelbtn", GCB.cellConfig)
			GCB.cellConfig.btnCancel:SetText("CANCEL")
			GCB.cellConfig.btnCancel:SetPoint("BOTTOMLEFT", GCB.cellConfig, "BOTTOMCENTER", 0, -10)
			GCB.cellConfig.btnCancel:SetEnabled(true)
			GCB.cellConfig.btnCancel.Event.LeftPress = function()
				GCB.cellConfig:SetVisible(false)
			end
			
		GCB.cellConfig.bg = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg", GCB.cellConfig)
			GCB.cellConfig.bg:SetPoint("TOPLEFT", GCB.cellConfig, "TOPLEFT", 20, 25)
			GCB.cellConfig.bg:SetFontColor(1,1,1,1)
			GCB.cellConfig.bg:SetFontSize(14)
			GCB.cellConfig.bg:SetText("Background Color                 Cell: " .. cellInfo.row .. ", " .. cellInfo.column)
			
			GCB.cellConfig.bg.preview = UI.CreateFrame("Frame", AddonId .. "_cellConfig_bg_preview", GCB.cellConfig.bg)
				GCB.cellConfig.bg.preview:SetPoint("TOPLEFT", GCB.cellConfig.bg, "BOTTOMLEFT", 0, 5)
				GCB.cellConfig.bg.preview:SetHeight(60)
				GCB.cellConfig.bg.preview:SetWidth(45)
				GCB.cellConfig.bg.preview:SetBackgroundColor(0,0,0,1)
			
			GCB.cellConfig.bg.red = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg_red", GCB.cellConfig.bg)
				GCB.cellConfig.bg.red:SetPoint("TOPLEFT", GCB.cellConfig.bg.preview, "TOPRIGHT", 22, 0)
				GCB.cellConfig.bg.red:SetFontColor(1,1,1,1)
				GCB.cellConfig.bg.red:SetFontSize(12)
				GCB.cellConfig.bg.red:SetText("Red")
			
			GCB.cellConfig.bg.red.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_bg_red_slider", GCB.cellConfig.bg.red)
				GCB.cellConfig.bg.red.slider:SetPoint("CENTERLEFT", GCB.cellConfig.bg.red, "CENTERRIGHT", 12, 6)
				GCB.cellConfig.bg.red.slider:SetRange(0,255)
				GCB.cellConfig.bg.red.slider:SetWidth(120)
				GCB.cellConfig.bg.red.slider:SetPosition(0)
				GCB.cellConfig.bg.red.slider.Event.SliderChange = function()
					GCB.cellConfig.bg.red.value:SetText(tostring(GCB.cellConfig.bg.red.slider:GetPosition()))
					GCB.cellConfig.bg.preview:SetBackgroundColor(GCB.cellConfig.bg.red.slider:GetPosition()/255,GCB.cellConfig.bg.green.slider:GetPosition()/255,GCB.cellConfig.bg.blue.slider:GetPosition()/255,1)
				end
			
			GCB.cellConfig.bg.red.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg_red_value", GCB.cellConfig.bg.red)
				GCB.cellConfig.bg.red.value:SetPoint("CENTERLEFT", GCB.cellConfig.bg.red.slider, "CENTERRIGHT", 12, -6)
				GCB.cellConfig.bg.red.value:SetFontColor(1,1,1,1)
				GCB.cellConfig.bg.red.value:SetFontSize(12)
				GCB.cellConfig.bg.red.value:SetText(tostring(GCB.cellConfig.bg.red.slider:GetPosition()))
			
			GCB.cellConfig.bg.green = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg_green", GCB.cellConfig.bg)
				GCB.cellConfig.bg.green:SetPoint("CENTERLEFT", GCB.cellConfig.bg.preview, "CENTERRIGHT", 10, 0)
				GCB.cellConfig.bg.green:SetFontColor(1,1,1,1)
				GCB.cellConfig.bg.green:SetFontSize(12)
				GCB.cellConfig.bg.green:SetText("Green")
			
			GCB.cellConfig.bg.green.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_bg_green_slider", GCB.cellConfig.bg.green)
				GCB.cellConfig.bg.green.slider:SetPoint("CENTERLEFT", GCB.cellConfig.bg.green, "CENTERRIGHT", 12, 6)
				GCB.cellConfig.bg.green.slider:SetRange(0,255)
				GCB.cellConfig.bg.green.slider:SetWidth(120)
				GCB.cellConfig.bg.green.slider:SetPosition(0)
				GCB.cellConfig.bg.green.slider.Event.SliderChange = function()
					GCB.cellConfig.bg.green.value:SetText(tostring(GCB.cellConfig.bg.green.slider:GetPosition()))
					GCB.cellConfig.bg.preview:SetBackgroundColor(GCB.cellConfig.bg.red.slider:GetPosition()/255,GCB.cellConfig.bg.green.slider:GetPosition()/255,GCB.cellConfig.bg.blue.slider:GetPosition()/255,1)
				end
			
			GCB.cellConfig.bg.green.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg_green_value", GCB.cellConfig.bg.green)
				GCB.cellConfig.bg.green.value:SetPoint("CENTERLEFT", GCB.cellConfig.bg.green.slider, "CENTERRIGHT", 12, -6)
				GCB.cellConfig.bg.green.value:SetFontColor(1,1,1,1)
				GCB.cellConfig.bg.green.value:SetFontSize(12)
				GCB.cellConfig.bg.green.value:SetText(tostring(GCB.cellConfig.bg.green.slider:GetPosition()))
			
			GCB.cellConfig.bg.blue = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg_blue", GCB.cellConfig.bg)
				GCB.cellConfig.bg.blue:SetPoint("BOTTOMLEFT", GCB.cellConfig.bg.preview, "BOTTOMRIGHT", 19, 0)
				GCB.cellConfig.bg.blue:SetFontColor(1,1,1,1)
				GCB.cellConfig.bg.blue:SetFontSize(12)
				GCB.cellConfig.bg.blue:SetText("Blue")
			
			GCB.cellConfig.bg.blue.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_bg_blue_slider", GCB.cellConfig.bg.blue)
				GCB.cellConfig.bg.blue.slider:SetPoint("CENTERLEFT", GCB.cellConfig.bg.blue, "CENTERRIGHT", 12, 6)
				GCB.cellConfig.bg.blue.slider:SetRange(0,255)
				GCB.cellConfig.bg.blue.slider:SetWidth(120)
				GCB.cellConfig.bg.blue.slider:SetPosition(0)
				GCB.cellConfig.bg.blue.slider.Event.SliderChange = function()
					GCB.cellConfig.bg.blue.value:SetText(tostring(GCB.cellConfig.bg.blue.slider:GetPosition()))
					GCB.cellConfig.bg.preview:SetBackgroundColor(GCB.cellConfig.bg.red.slider:GetPosition()/255,GCB.cellConfig.bg.green.slider:GetPosition()/255,GCB.cellConfig.bg.blue.slider:GetPosition()/255,1)
				end
			
			GCB.cellConfig.bg.blue.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_bg_blue_value", GCB.cellConfig.bg.blue)
				GCB.cellConfig.bg.blue.value:SetPoint("CENTERLEFT", GCB.cellConfig.bg.blue.slider, "CENTERRIGHT", 12, -6)
				GCB.cellConfig.bg.blue.value:SetFontColor(1,1,1,1)
				GCB.cellConfig.bg.blue.value:SetFontSize(12)
				GCB.cellConfig.bg.blue.value:SetText(tostring(GCB.cellConfig.bg.blue.slider:GetPosition()))
			
		GCB.cellConfig.stat = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat", GCB.cellConfig)
			GCB.cellConfig.stat:SetPoint("TOPLEFT", GCB.cellConfig.bg, "TOPLEFT", 0, 100)
			GCB.cellConfig.stat:SetFontColor(1,1,1,1)
			GCB.cellConfig.stat:SetFontSize(14)
			GCB.cellConfig.stat:SetText("Stack Color")
			
			GCB.cellConfig.stat.preview = UI.CreateFrame("Frame", AddonId .. "_cellConfig_stat_preview", GCB.cellConfig.stat)
				GCB.cellConfig.stat.preview:SetPoint("TOPLEFT", GCB.cellConfig.stat, "BOTTOMLEFT", 0, 5)
				GCB.cellConfig.stat.preview:SetHeight(60)
				GCB.cellConfig.stat.preview:SetWidth(45)
				GCB.cellConfig.stat.preview:SetBackgroundColor(1,1,1,1)
			
			GCB.cellConfig.stat.red = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat_red", GCB.cellConfig.stat)
				GCB.cellConfig.stat.red:SetPoint("TOPLEFT", GCB.cellConfig.stat.preview, "TOPRIGHT", 22, 0)
				GCB.cellConfig.stat.red:SetFontColor(1,1,1,1)
				GCB.cellConfig.stat.red:SetFontSize(12)
				GCB.cellConfig.stat.red:SetText("Red")
			
			GCB.cellConfig.stat.red.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_stat_red_slider", GCB.cellConfig.stat.red)
				GCB.cellConfig.stat.red.slider:SetPoint("CENTERLEFT", GCB.cellConfig.stat.red, "CENTERRIGHT", 12, 6)
				GCB.cellConfig.stat.red.slider:SetRange(0,255)
				GCB.cellConfig.stat.red.slider:SetWidth(120)
				GCB.cellConfig.stat.red.slider:SetPosition(255)
				GCB.cellConfig.stat.red.slider.Event.SliderChange = function()
					GCB.cellConfig.stat.red.value:SetText(tostring(GCB.cellConfig.stat.red.slider:GetPosition()))
					GCB.cellConfig.stat.preview:SetBackgroundColor(GCB.cellConfig.stat.red.slider:GetPosition()/255,GCB.cellConfig.stat.green.slider:GetPosition()/255,GCB.cellConfig.stat.blue.slider:GetPosition()/255,1)
				end
			
			GCB.cellConfig.stat.red.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat_red_value", GCB.cellConfig.stat.red)
				GCB.cellConfig.stat.red.value:SetPoint("CENTERLEFT", GCB.cellConfig.stat.red.slider, "CENTERRIGHT", 12, -6)
				GCB.cellConfig.stat.red.value:SetFontColor(1,1,1,1)
				GCB.cellConfig.stat.red.value:SetFontSize(12)
				GCB.cellConfig.stat.red.value:SetText(tostring(GCB.cellConfig.stat.red.slider:GetPosition()))
			
			GCB.cellConfig.stat.green = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat_green", GCB.cellConfig.stat)
				GCB.cellConfig.stat.green:SetPoint("CENTERLEFT", GCB.cellConfig.stat.preview, "CENTERRIGHT", 10, 0)
				GCB.cellConfig.stat.green:SetFontColor(1,1,1,1)
				GCB.cellConfig.stat.green:SetFontSize(12)
				GCB.cellConfig.stat.green:SetText("Green")
			
			GCB.cellConfig.stat.green.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_stat_green_slider", GCB.cellConfig.stat.green)
				GCB.cellConfig.stat.green.slider:SetPoint("CENTERLEFT", GCB.cellConfig.stat.green, "CENTERRIGHT", 12, 6)
				GCB.cellConfig.stat.green.slider:SetRange(0,255)
				GCB.cellConfig.stat.green.slider:SetWidth(120)
				GCB.cellConfig.stat.green.slider:SetPosition(255)
				GCB.cellConfig.stat.green.slider.Event.SliderChange = function()
					GCB.cellConfig.stat.green.value:SetText(tostring(GCB.cellConfig.stat.green.slider:GetPosition()))
					GCB.cellConfig.stat.preview:SetBackgroundColor(GCB.cellConfig.stat.red.slider:GetPosition()/255,GCB.cellConfig.stat.green.slider:GetPosition()/255,GCB.cellConfig.stat.blue.slider:GetPosition()/255,1)
				end
			
			GCB.cellConfig.stat.green.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat_green_value", GCB.cellConfig.stat.green)
				GCB.cellConfig.stat.green.value:SetPoint("CENTERLEFT", GCB.cellConfig.stat.green.slider, "CENTERRIGHT", 12, -6)
				GCB.cellConfig.stat.green.value:SetFontColor(1,1,1,1)
				GCB.cellConfig.stat.green.value:SetFontSize(12)
				GCB.cellConfig.stat.green.value:SetText(tostring(GCB.cellConfig.stat.green.slider:GetPosition()))
			
			GCB.cellConfig.stat.blue = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat_blue", GCB.cellConfig.stat)
				GCB.cellConfig.stat.blue:SetPoint("BOTTOMLEFT", GCB.cellConfig.stat.preview, "BOTTOMRIGHT", 19, 0)
				GCB.cellConfig.stat.blue:SetFontColor(1,1,1,1)
				GCB.cellConfig.stat.blue:SetFontSize(12)
				GCB.cellConfig.stat.blue:SetText("Blue")
			
			GCB.cellConfig.stat.blue.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_stat_blue_slider", GCB.cellConfig.stat.blue)
				GCB.cellConfig.stat.blue.slider:SetPoint("CENTERLEFT", GCB.cellConfig.stat.blue, "CENTERRIGHT", 12, 6)
				GCB.cellConfig.stat.blue.slider:SetRange(0,255)
				GCB.cellConfig.stat.blue.slider:SetWidth(120)
				GCB.cellConfig.stat.blue.slider:SetPosition(255)
				GCB.cellConfig.stat.blue.slider.Event.SliderChange = function()
					GCB.cellConfig.stat.blue.value:SetText(tostring(GCB.cellConfig.stat.blue.slider:GetPosition()))
					GCB.cellConfig.stat.preview:SetBackgroundColor(GCB.cellConfig.stat.red.slider:GetPosition()/255,GCB.cellConfig.stat.green.slider:GetPosition()/255,GCB.cellConfig.stat.blue.slider:GetPosition()/255,1)
				end
			
			GCB.cellConfig.stat.blue.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_stat_blue_value", GCB.cellConfig.stat.blue)
				GCB.cellConfig.stat.blue.value:SetPoint("CENTERLEFT", GCB.cellConfig.stat.blue.slider, "CENTERRIGHT", 12, -6)
				GCB.cellConfig.stat.blue.value:SetFontColor(1,1,1,1)
				GCB.cellConfig.stat.blue.value:SetFontSize(12)
				GCB.cellConfig.stat.blue.value:SetText(tostring(GCB.cellConfig.stat.blue.slider:GetPosition()))
				
		GCB.cellConfig.alpha = UI.CreateFrame("Text", AddonId .. "_cellConfig_alpha", GCB.cellConfig)
			GCB.cellConfig.alpha:SetPoint("TOPLEFT", GCB.cellConfig.stat.preview, "BOTTOMRIGHT", 11, 20)
			GCB.cellConfig.alpha:SetFontColor(1,1,1,1)
			GCB.cellConfig.alpha:SetFontSize(12)
			GCB.cellConfig.alpha:SetText("Alpha")
			
		GCB.cellConfig.alpha.slider = UI.CreateFrame("RiftSlider", AddonId .. "_cellConfig_alpha_slider", GCB.cellConfig.alpha)
			GCB.cellConfig.alpha.slider:SetPoint("CENTERLEFT", GCB.cellConfig.alpha, "CENTERRIGHT", 12, 6)
			GCB.cellConfig.alpha.slider:SetRange(0,100)
			GCB.cellConfig.alpha.slider:SetWidth(120)
			GCB.cellConfig.alpha.slider:SetPosition(0)
			GCB.cellConfig.alpha.slider.Event.SliderChange = function()
				GCB.cellConfig.alpha.value:SetText(tostring(GCB.cellConfig.alpha.slider:GetPosition()))
			end
			
		GCB.cellConfig.alpha.value = UI.CreateFrame("Text", AddonId .. "_cellConfig_alpha_value", GCB.cellConfig.alpha)
			GCB.cellConfig.alpha.value:SetPoint("CENTERLEFT", GCB.cellConfig.alpha.slider, "CENTERRIGHT", 12, -6)
			GCB.cellConfig.alpha.value:SetFontColor(1,1,1,1)
			GCB.cellConfig.alpha.value:SetFontSize(12)
			GCB.cellConfig.alpha.value:SetText(tostring(GCB.cellConfig.alpha.slider:GetPosition()))
	end
	if cellInfo then
		GCB.cellConfig:SetVisible(true)
		GCB.cellConfig.bg:SetText("Background Color                 Cell: " .. cellInfo.row .. ", " .. cellInfo.column)
		local bgr,bgg,bgb = cellInfo.back:GetBackgroundColor()
		local lblr,lblg,lblb = cellInfo.text:GetFontColor()
		GCB.cellConfig.bg.preview:SetBackgroundColor(bgr,bgg,bgb,1)
		GCB.cellConfig.bg.red.slider:SetPosition(math.floor(bgr*255))
		GCB.cellConfig.bg.green.slider:SetPosition(math.floor(bgg*255))
		GCB.cellConfig.bg.blue.slider:SetPosition(math.floor(bgb*255))
		if cellInfo.statr and cellInfo.statg and cellInfo.statb and cellInfo.alpha then
			GCB.cellConfig.stat.preview:SetBackgroundColor(cellInfo.statr,cellInfo.statg,cellInfo.statb,1)
			GCB.cellConfig.stat.red.slider:SetPosition(math.floor(cellInfo.statr*255))
			GCB.cellConfig.stat.green.slider:SetPosition(math.floor(cellInfo.statg*255))
			GCB.cellConfig.stat.blue.slider:SetPosition(math.floor(cellInfo.statb*255))
			GCB.cellConfig.alpha.slider:SetPosition(math.floor(cellInfo.alpha*100))
		else
			GCB.cellConfig.stat.preview:SetBackgroundColor(1,1,1,1)
			GCB.cellConfig.stat.red.slider:SetPosition(255)
			GCB.cellConfig.stat.green.slider:SetPosition(255)
			GCB.cellConfig.stat.blue.slider:SetPosition(255)
			GCB.cellConfig.alpha.slider:SetPosition(0)
		end
	end
	
	function GCB.cellConfig.btnOK.Event.LeftPress()
		cellInfo.back:SetBackgroundColor(GCB.cellConfig.bg.red.slider:GetPosition()/255,GCB.cellConfig.bg.green.slider:GetPosition()/255,GCB.cellConfig.bg.blue.slider:GetPosition()/255,1)
		cellInfo.text:SetFontColor(GCB.cellConfig.stat.red.slider:GetPosition()/255,GCB.cellConfig.stat.green.slider:GetPosition()/255,GCB.cellConfig.stat.blue.slider:GetPosition()/255,1)
		cellInfo.statr = GCB.cellConfig.stat.red.slider:GetPosition()/255
		cellInfo.statg = GCB.cellConfig.stat.green.slider:GetPosition()/255
		cellInfo.statb = GCB.cellConfig.stat.blue.slider:GetPosition()/255
		cellInfo.alpha = GCB.cellConfig.alpha.slider:GetPosition()/100
		GCB.cellConfig:SetVisible(false)
	end

end

local function Create(configuration)

	Command.System.Watchdog.Quiet()

	local rowText = configuration.rowText
	local columnText = configuration.columnText
	
	GCB.configTable = {}
	for idx = 1, 20, 1 do
		table.insert(GCB.configTable, configuration[idx])
	end

	GCB.display[configuration.id] = UI.CreateFrame("Frame", AddonId .. "_display_" .. configuration.id, WT.Context)
		GCB.display[configuration.id]:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 350, 350)
		GCB.display[configuration.id]:SetHeight(rowText*20)
		GCB.display[configuration.id]:SetWidth(columnText*90)
		GCB.display[configuration.id]:SetLayer(5)
		
		GCB.display[configuration.id].data = {}
		
	for column, rows in ipairs(GCB.configTable) do
	
		GCB.display[configuration.id].data[column] = {}
		
		for row, data in ipairs(rows) do
			if data.name then
				local stackNum = 0
				if data.name == "platinum" then
				stackNum = Coin(Inspect.Currency.Detail("coin").stack, 1)
				elseif data.name == "gold" then
				stackNum = Coin(Inspect.Currency.Detail("coin").stack, 2)
				elseif data.name == "silver" then
				stackNum = Coin(Inspect.Currency.Detail("coin").stack, 3)
				elseif Inspect.Currency.Detail(data.name) then
				stackNum = Inspect.Currency.Detail(data.name).stack
				else
				stackNum = 0
				end
				
				if not data.Colors then
					data.Colors = { Back = {0,0,0,0.5}, Label = {1,1,1}, Stat = {1,1,1}}
				end
				
				local cell = UI.CreateFrame("Frame", AddonId .. "_display_" .. configuration.id .. "_" .. column .. "_" .. row, GCB.display[configuration.id])
					cell:SetPoint("TOPLEFT", GCB.display[configuration.id], "TOPLEFT", 90*(column-1), 20*(row-1))
					cell:SetHeight(20)
					cell:SetWidth(90)
					cell:SetBackgroundColor(data.Colors.Back[1],data.Colors.Back[2],data.Colors.Back[3],data.Colors.Back[4])
					cell:SetLayer(10)
					cell:EventAttach(Event.UI.Input.Mouse.Cursor.In, function() 
						if string.len(data.name) > 20 and configuration.tooltip then
							Command.Tooltip(data.name)
						end
					end, "MouseIn")
					cell:EventAttach(Event.UI.Input.Mouse.Cursor.Out, function() 
							Command.Tooltip(nil)
					end, "MouseOut")
					cell:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function()
						local type, unitID, buff = Inspect.Tooltip()
						if type == nil then
							if string.len(data.name) > 20 and configuration.tooltip then
								Command.Tooltip(data.name)
							end
						end
					end, "MouseMove")
					
				cell.icon = UI.CreateFrame("Texture", AddonId .. "_display_" .. configuration.id .. "_" .. column .. "_" .. row .. "_icon", cell)
					cell.icon:SetPoint("CENTERLEFT", cell, "CENTERLEFT", 2, 0)
					cell.icon:SetHeight(16)
					cell.icon:SetWidth(16)
					cell.icon:SetVisible(true)
					cell.icon:SetLayer(30)
					if data.name == "credit" then
						cell.icon:SetTexture(AddonId, data.icon)
					else
						cell.icon:SetTexture("Rift", data.icon)
					end

				cell.stack = UI.CreateFrame("Text", AddonId .. "_display_" .. configuration.id .. "_" .. column .. "_" .. row .. "_stack", cell)
					cell.stack:SetPoint("CENTERLEFT", cell.icon, "CENTERRIGHT", 2, 0)
					cell.stack:SetFontColor(data.Colors.Stat[1],data.Colors.Stat[2],data.Colors.Stat[3],1)
					cell.stack:SetFontSize(14)
					cell.stack:SetText(tostring(stackNum))
					cell.stack:SetVisible(true)
					cell.stack:SetLayer(20)
						
				cell.name = data.name
				
				GCB.display[configuration.id].data[column][row] = cell
			end
		end
	end
	if GCB.layout then
		GCB.layout.SetText(1,1)
	end
	if GCB.preview then
		for cell, data in pairs(GCB.preview.view:GetChildren()) do
			cell.back:SetBackgroundColor(0.5,0.5,0.5,1)
			cell.text:SetFontColor(1,1,1,1)
			cell.statr = nil
			cell.statg = nil
			cell.statb = nil
			cell.alpha = nil
			cell.iconName = nil
			cell.icon:SetTexture("Rift", "")
			cell.text:SetText("")
			cell.text:SetVisible(false)
			cell.cname = nil
			cell.ltext = nil
		end
	end
	--[[display.Event.Size = 
		function()
			for column, rows in ipairs(display.data) do
				for row, data in ipairs(rows) do]]--
	
	return GCB.display[configuration.id]--, { resizable={(columnText*175), (rowText*20), (columnText*875), (rowText*100) } }

end

local dialog = false

local function ConfigDialog(container)

	Command.System.Watchdog.Quiet()
	
	GCB.container = container

	GCB.label = UI.CreateFrame("Text", AddonId .. "_label", container)
		GCB.label:SetPoint("TOPLEFT", container, "TOPLEFT")
		GCB.label:SetPoint("RIGHT", container, "RIGHT")
		GCB.label:SetFontSize(12)
		GCB.label:SetText("The Stats Gadget shows the selected stats for the player.")
	
	GCB.layout = UI.CreateFrame("Frame", AddonId .. "_layout", container)
		GCB.layout:SetPoint("TOPLEFT", GCB.label, "BOTTOMLEFT", 0, 5)
		GCB.layout:SetPoint("RIGHT", container, "RIGHT")
		GCB.layout:SetHeight(20)
		
		GCB.layout.label = UI.CreateFrame("Text", AddonId .. "_layout_label", GCB.layout)
			GCB.layout.label:SetText("Layout")
			GCB.layout.label:SetWidth(200)
			GCB.layout.label:SetPoint("TOPLEFT", GCB.layout, "TOPLEFT")
			
		GCB.layout.Rows = {}
		
		GCB.layout.Rows.label = UI.CreateFrame("Text", AddonId .. "_layout_Rows_label", GCB.layout)
			GCB.layout.Rows.label:SetText("Rows:")
			GCB.layout.Rows.label:SetPoint("CENTERLEFT", GCB.layout.label, "CENTERRIGHT", 8, 0)
		
		GCB.layout.Rows.value = UI.CreateFrame("Text", AddonId .. "_layout_Rows_value", GCB.layout)
			GCB.layout.Rows.value:SetText("1")
			GCB.layout.Rows.value:SetWidth(50)
			GCB.layout.Rows.value:SetBackgroundColor(0.2,0.2,0.2,0.9)
			GCB.layout.Rows.value:SetPoint("CENTERLEFT", GCB.layout.Rows.label, "CENTERRIGHT", 5, 0)
			
		GCB.layout.Rows.Icon = UI.CreateFrame("Texture", AddonId .. "_layout_Rows_Icon", GCB.layout.Rows.value)
			GCB.layout.Rows.Icon:SetTexture(AddonId, "img/wtDropDown.png")
			GCB.layout.Rows.Icon:SetHeight(GCB.layout.Rows.value:GetHeight())
			GCB.layout.Rows.Icon:SetWidth(GCB.layout.Rows.value:GetHeight())
			GCB.layout.Rows.Icon:SetPoint("TOPLEFT", GCB.layout.Rows.value, "TOPRIGHT", -10, 0)
			
		GCB.layout.Rows.menu = WT.Control.Menu.Create(container, { "1       ", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20" }, function(value) GCB.layout.Rows.value:SetText(value); previewUpdate("row", value) end, sort)
			GCB.layout.Rows.menu:SetPoint("TOPRIGHT", GCB.layout.Rows.Icon, "BOTTOMCENTER")
			
		GCB.layout.Rows.Icon.Event.LeftClick = function() GCB.layout.Rows.menu:Toggle() end
		GCB.layout.Rows.value.Event.LeftClick = function() GCB.layout.Rows.menu:Toggle() end
		
		GCB.layout.Columns = {}
		
		GCB.layout.Columns.label = UI.CreateFrame("Text", AddonId .. "_layout_Columns_label", GCB.layout)
			GCB.layout.Columns.label:SetText("Columns:")
			GCB.layout.Columns.label:SetPoint("CENTERLEFT", GCB.layout.Rows.Icon, "CENTERRIGHT", 20, 0)
			
		GCB.layout.Columns.value = UI.CreateFrame("Text", AddonId .. "_layout_Columns_value", GCB.layout)
			GCB.layout.Columns.value:SetText("1")
			GCB.layout.Columns.value:SetWidth(50)
			GCB.layout.Columns.value:SetBackgroundColor(0.2,0.2,0.2,0.9)
			GCB.layout.Columns.value:SetPoint("CENTERLEFT", GCB.layout.Columns.label, "CENTERRIGHT", 5, 0)
			
		GCB.layout.Columns.Icon = UI.CreateFrame("Texture", AddonId .. "_layout_Columns_Icon", GCB.layout.Columns.value)
			GCB.layout.Columns.Icon:SetTexture(AddonId, "img/wtDropDown.png")
			GCB.layout.Columns.Icon:SetHeight(GCB.layout.Columns.value:GetHeight())
			GCB.layout.Columns.Icon:SetWidth(GCB.layout.Columns.value:GetHeight())
			GCB.layout.Columns.Icon:SetPoint("TOPLEFT", GCB.layout.Columns.value, "TOPRIGHT", -10, 0)
			
		GCB.layout.Columns.menu = WT.Control.Menu.Create(container, { "1       ", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20" }, function(value) GCB.layout.Columns.value:SetText(value); previewUpdate("column", value) end, sort)
			GCB.layout.Columns.menu:SetPoint("TOPRIGHT", GCB.layout.Columns.Icon, "BOTTOMCENTER")
			
		GCB.layout.Columns.Icon.Event.LeftClick = function() GCB.layout.Columns.menu:Toggle() end
		GCB.layout.Columns.value.Event.LeftClick = function() GCB.layout.Columns.menu:Toggle() end
		
		
		GCB.layout.GetText = function() return {GCB.layout.Rows.value:GetText(), GCB.layout.Columns.value:GetText()} end
		GCB.layout.SetText = 
			function(row,column)
				if row then
					GCB.layout.Rows.value:SetText(tostring(row))
					if onchange then onchange(tostring(row)) end
					previewUpdate("row", row)
				end
				if column then
					GCB.layout.Columns.value:SetText(tostring(column))
					if onchange then onchange(tostring(column)) end
					previewUpdate("column", column)
				end
				for cell, data in pairs(GCB.preview.view:GetChildren()) do
					cell.text:SetText("")
					cell.back:SetBackgroundColor(0.5,0.5,0.5,1)
					cell.text:SetVisible(true)
					if cell.cname then
						cell.cname = nil
					end
				end
			end
	
	GCB.tooltip = UI.CreateFrame("Frame", AddonId .. "_tooltip", container)
		GCB.tooltip:SetPoint("TOPLEFT", GCB.layout, "BOTTOMLEFT", 0, 2)
		GCB.tooltip:SetPoint("RIGHT", container, "RIGHT")
		GCB.tooltip:SetHeight(20)
		
		GCB.tooltip.label = UI.CreateFrame("Text", AddonId .. "_tooltip_label", GCB.tooltip)
			GCB.tooltip.label:SetText("Display Tooltip on Mouseover?")
			GCB.tooltip.label:SetWidth(200)
			GCB.tooltip.label:SetPoint("TOPLEFT", GCB.tooltip, "TOPLEFT")
			
		GCB.tooltip.label.check = UI.CreateFrame("RiftCheckbox", AddonId .. "_tooltip_label_check", GCB.tooltip.label)
			GCB.tooltip.label.check:SetPoint("CENTERLEFT", GCB.tooltip.label, "CENTERRIGHT", 8, 0)
			GCB.tooltip.label.check:SetHeight(20)
			GCB.tooltip.label.check:SetWidth(20)
			GCB.tooltip.label.check:SetEnabled(true)
			
	GCB.currencies = UI.CreateFrame("Frame", AddonId .. "_currencies", container)
		GCB.currencies.label = UI.CreateFrame("Text", AddonId .. "_currencies_label", GCB.currencies)
			GCB.currencies.label:SetPoint("TOPLEFT", GCB.tooltip, "BOTTOMLEFT", 0, 2)
			GCB.currencies.label:SetPoint("RIGHT", container, "RIGHT")
			GCB.currencies.label:SetFontSize(12)
			GCB.currencies.label:SetText("Drag the desired stats into an open cell in the preview window below.")
		
		GCB.currencies:SetPoint("TOPLEFT", GCB.currencies.label, "BOTTOMLEFT", 5, 3)
		GCB.currencies:SetHeight(200)
		GCB.currencies:SetWidth(484)
		GCB.currencies:SetBackgroundColor(0.2,0.2,0.2,0.9)
		GCB.currencies.Event.WheelForward = function()
			GCB.currencies.scrollbar:NudgeUp()
		end
		GCB.currencies.Event.WheelBack = function()
			GCB.currencies.scrollbar:NudgeDown()
		end
		
		GCB.currencies.view = UI.CreateFrame("Frame", AddonId .. "_currencies_view", GCB.currencies)
			GCB.currencies.view:SetPoint("TOPLEFT", GCB.currencies, "TOPLEFT")
			GCB.currencies.view:SetHeight(200)

		GCB.currencies.scrollbar = UI.CreateFrame("RiftScrollbar", AddonId .. "_currencies_scrollbar", GCB.currencies)
			GCB.currencies.scrollbar:SetPoint("TOPLEFT", GCB.currencies, "TOPRIGHT", 5, 0)
			GCB.currencies.scrollbar:SetPoint("BOTTOMLEFT", GCB.currencies, "BOTTOMRIGHT", 5, 0)
			GCB.currencies.scrollbar:SetThickness(15)
			--GCB.currencies.scrollbar:SetRange(1,20)
			GCB.currencies.scrollbar.Event.WheelForward = function()
				GCB.currencies.scrollbar:NudgeUp()
			end
			GCB.currencies.scrollbar.Event.WheelBack = function()
				GCB.currencies.scrollbar:NudgeDown()
			end
			GCB.currencies.scrollbar.Event.ScrollbarChange = function()
				local pos = math.floor(GCB.currencies.scrollbar:GetPosition())-1
				GCB.currencies.view:SetPoint("TOPLEFT", GCB.currencies, "TOPLEFT", 0, -(pos*20))
				for cell,data in pairs(GCB.currencies.view:GetChildren()) do
					if cell.row < pos or cell.row >= pos+10 then
						cell:SetVisible(false)
					else
						cell:SetVisible(true)
					end
				end
			end
		
	
	local function addCell(name, text, col, row, icon)
		
		local cell = UI.CreateFrame("Frame", AddonId .. "_currencies_view_" .. name, GCB.currencies.view)
			cell:SetPoint("TOPLEFT", GCB.currencies.view, "TOPLEFT", 121*col, 20*row)
			cell.row = row
			cell.column = col
			cell:SetHeight(20)
			cell:SetWidth(121)
			cell:SetBackgroundColor(1,1,1,0)
			cell:SetLayer(10)
			cell.Event.MouseIn = function() cell:SetBackgroundColor(1,1,1,1) end
			cell.Event.MouseOut = function() cell:SetBackgroundColor(1,1,1,0) end
			function cell.Event.LeftDown()
				if icon then
					mouseFrame.text:SetText(text)
					mouseFrame:SetVisible(true)
					mouseFrame.cname = name
					mouseFrame.iconName = icon
					if name == "credit" then
						mouseFrame.icon:SetTexture(AddonId, icon)
					else
						mouseFrame.icon:SetTexture("Rift", icon)
					end
					
					local mouse = Inspect.Mouse()
						mouseFrame:SetPoint("CENTER", WT.Context, "CENTER", mouse.x-18, mouse.y-18)
				end
			end
			function cell.Event.LeftUp()
				mouseFrame:SetVisible(false)
			end
			function cell.Event.LeftUpoutside()
				mouseFrame:SetVisible(false)
			end
			
		cell.back = UI.CreateFrame("Frame", AddonId .. "_currencies_view_" .. name .. "_back", cell)
			cell.back:SetPoint("TOPLEFT", cell, "TOPLEFT", 2, 2)
			cell.back:SetPoint("BOTTOMRIGHT", cell, "BOTTOMRIGHT", -2, -2)
			cell.back:SetBackgroundColor(0,0,0,1)
			cell.back:SetVisible(true)
			cell.back:SetLayer(20)
			
		if icon then
			cell.icon = UI.CreateFrame("Texture", AddonId .. "_currencies_view_" .. name .. "_icon", cell.back)
				cell.icon:SetPoint("CENTERLEFT", cell.back, "CENTERLEFT", 2, 0)
				cell.icon:SetHeight(16)
				cell.icon:SetWidth(16)
				cell.icon:SetVisible(true)
				cell.icon:SetLayer(30)
				if name == "credit" then
					cell.icon:SetTexture(AddonId, icon)
				else
					cell.icon:SetTexture("Rift", icon)
				end
		end
		
		cell.text = UI.CreateFrame("Text", AddonId .. "_currencies_view_" .. name .. "_text", cell.back)
			if icon then
				cell.text:SetPoint("CENTERLEFT", cell.icon, "CENTERRIGHT", 2, 0)
				cell.text:SetWidth(cell.back:GetWidth()-20)
			else
				cell.text:SetPoint("CENTERLEFT", cell.back, "CENTERLEFT", 2, 0)
				cell.text:SetWidth(cell.back:GetWidth()-4)
			end
			cell.text:SetFontColor(1,1,1,1)
			if icon then
				cell.text:SetFontSize(13)
			else
				cell.text:SetFontSize(15)
			end
			cell.text:SetText(text)
			cell.text:SetVisible(true)
			cell.text:SetLayer(30)
			
		if cell.row > 9 then
			cell:SetVisible(false)
		end
		
	end

	GCB.currencies.lists = {}
	GCB.currencies.lists.category = {}
	GCB.currencies.lists.sorted = {}
	
	for id,state in pairs(Inspect.Currency.Category.List()) do
		table.insert(GCB.currencies.lists.category, {ID = id, name = Inspect.Currency.Category.Detail(id).name})
		GCB.currencies.lists.sorted[id] = {}
	end
	for id,value in pairs(Inspect.Currency.List()) do
		local detail = Inspect.Currency.Detail(id)
		for cat,data in pairs(GCB.currencies.lists.sorted) do
			if detail.category == cat then
				GCB.currencies.lists.sorted[cat][detail.name]=detail
			end
		end
	end
	
	GCB.firstSetMax = 0
	GCB.totalMax = 0
	
	for i=0,3,1 do
		local count = 0
		if GCB.currencies.lists.category[i+1] then
			addCell(GCB.currencies.lists.category[i+1].ID, GCB.currencies.lists.category[i+1].name, i, 0)
			for id,data in pairs(GCB.currencies.lists.sorted[GCB.currencies.lists.category[i+1].ID]) do
				if data.id == "coin" then
					addCell("platinum", "Platinum", i, count+1, "coins_platinum.png.dds")
					addCell("gold", "Gold", i, count+2, "coins_gold.png.dds")
					addCell("silver", "Silver", i, count+3, "coins_silver.png.dds")
					count = count + 3
				elseif data.id == "credit" then
					addCell("credit", "Credits", i, count+1, "img/credits.png")
					count = count + 1
				else
					addCell(data.id, data.name, i, count+1, data.icon)
					count = count + 1
				end
			end
			if count > GCB.firstSetMax then
				GCB.firstSetMax = count
			end
		end
	end
	
	for i=4,7,1 do
		local count = GCB.firstSetMax+2
		if GCB.currencies.lists.category[i+1] then
			addCell(GCB.currencies.lists.category[i+1].ID, GCB.currencies.lists.category[i+1].name, i-4, count)
			for id,data in pairs(GCB.currencies.lists.sorted[GCB.currencies.lists.category[i+1].ID]) do
				if data.id == "coin" then
					addCell("platinum", "Platinum", i-4, count+1, "coins_platinum.png.dds")
					addCell("gold", "Gold", i-4, count+2, "coins_gold.png.dds")
					addCell("silver", "Silver", i-4, count+3, "coins_silver.png.dds")
					count = count + 3
				elseif data.id == "credit" then
					addCell("credit", "Credits", i-4, count+1, "img/credits.png")
					count = count + 1
				else
					addCell(data.id, data.name, i-4, count+1, data.icon)
					count = count + 1
				end
			end
			if count+1 > GCB.totalMax then
				GCB.totalMax = count+1
			end
		end
	end
	
	GCB.secondSetMax = GCB.totalMax
	
	for i=8,11,1 do
		local count = GCB.secondSetMax+2
		if GCB.currencies.lists.category[i+1] then
			addCell(GCB.currencies.lists.category[i+1].ID, GCB.currencies.lists.category[i+1].name, i-8, count)
			for id,data in pairs(GCB.currencies.lists.sorted[GCB.currencies.lists.category[i+1].ID]) do
				if data.id == "coin" then
					addCell("platinum", "Platinum", i-8, count+1, "coins_platinum.png.dds")
					addCell("gold", "Gold", i-8, count+2, "coins_gold.png.dds")
					addCell("silver", "Silver", i-8, count+3, "coins_silver.png.dds")
					count = count + 3
				elseif data.id == "credit" then
					addCell("credit", "Credits", i-8, count+1, "img/credits.png")
					count = count + 1
				else
					addCell(data.id, data.name, i-8, count+1, data.icon)
					count = count + 1
				end
			end
			if count+1 > GCB.totalMax then
				GCB.totalMax = count+1
			end
		end
	end
	
	GCB.thirdSetMax = GCB.totalMax
	
	for i=12,15,1 do
		local count = GCB.thirdSetMax+2
		if GCB.currencies.lists.category[i+1] then
			addCell(GCB.currencies.lists.category[i+1].ID, GCB.currencies.lists.category[i+1].name, i-12, count)
			for id,data in pairs(GCB.currencies.lists.sorted[GCB.currencies.lists.category[i+1].ID]) do
				if data.id == "coin" then
					addCell("platinum", "Platinum", i-12, count+1, "coins_platinum.png.dds")
					addCell("gold", "Gold", i-12, count+2, "coins_gold.png.dds")
					addCell("silver", "Silver", i-12, count+3, "coins_silver.png.dds")
					count = count + 3
				elseif data.id == "credit" then
					addCell("credit", "Credits", i-12, count+1, "img/credits.png")
					count = count + 1
				else
					addCell(data.id, data.name, i-12, count+1, data.icon)
					count = count + 1
				end
			end
			if count+1 > GCB.totalMax then
				GCB.totalMax = count+1
			end
		end
	end
	
	if GCB.totalMax >= 10 then
		GCB.currencies.scrollbar:SetRange(1,GCB.totalMax-9)
	else	
		GCB.currencies.scrollbar:SetRange(1,1)
	end
	
	
	
	GCB.preview = UI.CreateFrame("Frame", AddonId .. "_preview", container)
		GCB.preview.label = UI.CreateFrame("Text", AddonId .. "_preview_label", GCB.preview)
			GCB.preview.label:SetPoint("TOPLEFT", GCB.currencies, "BOTTOMLEFT", -5, 7)
			GCB.preview.label:SetPoint("RIGHT", container, "RIGHT")
			GCB.preview.label:SetFontSize(12)
			GCB.preview.label:SetText("Right click on a cell for additional options specific to that cell.")
			
		GCB.preview:SetPoint("TOPLEFT", GCB.preview.label, "BOTTOMLEFT", 5, 3)
		GCB.preview:SetHeight(120)
		GCB.preview:SetWidth(484)
		GCB.preview:SetBackgroundColor(0.2,0.2,0.2,0.9)
		GCB.preview.Event.WheelForward = function()
			GCB.preview.scrollbarUp:NudgeUp()
		end
		GCB.preview.Event.WheelBack = function()
			GCB.preview.scrollbarUp:NudgeDown()
		end
		
		GCB.preview.view = UI.CreateFrame("Frame", AddonId .. "_preview_view", GCB.preview)
			GCB.preview.view:SetPoint("TOPLEFT", GCB.preview, "TOPLEFT")
			GCB.preview.view:SetHeight(120)

		GCB.preview.scrollbarUp = UI.CreateFrame("RiftScrollbar", AddonId .. "_preview_scrollbarUp", GCB.preview)
			GCB.preview.scrollbarUp:SetPoint("TOPLEFT", GCB.preview, "TOPRIGHT", 5, 0)
			GCB.preview.scrollbarUp:SetPoint("BOTTOMLEFT", GCB.preview, "BOTTOMRIGHT", 5, 0)
			GCB.preview.scrollbarUp:SetThickness(15)
			GCB.preview.scrollbarUp:SetRange(1,1)
			GCB.preview.scrollbarUp.Event.WheelForward = function()
				GCB.preview.scrollbarUp:NudgeUp()
			end
			GCB.preview.scrollbarUp.Event.WheelBack = function()
				GCB.preview.scrollbarUp:NudgeDown()
			end
			GCB.preview.scrollbarUp.Event.ScrollbarChange = function()
				local posUp = math.floor(GCB.preview.scrollbarUp:GetPosition())-1
				local posSide = math.floor(GCB.preview.scrollbarSide:GetPosition())-1
				local ctext = GCB.layout.Columns.value:GetText()
				GCB.preview.view:SetPoint("TOPLEFT", GCB.preview, "TOPLEFT", -(posSide*121), -(posUp*20))
				for cell,data in pairs(GCB.preview.view:GetChildren()) do
					if cell.column > posSide and cell.column <= posSide+4 and cell.column <= toNum(ctext) then
						if cell.row > posUp and cell.row <= posUp+6 then
							cell:SetVisible(true)
						else
							cell:SetVisible(false)
						end
					else
						cell:SetVisible(false)
					end
				end
			end
			
		GCB.preview.scrollbarSide = UI.CreateFrame("RiftScrollbar", AddonId .. "_preview_scrollbarSide", GCB.preview.view)
			GCB.preview.scrollbarSide:SetOrientation("horizontal")
			GCB.preview.scrollbarSide:SetParent(GCB.preview)
			GCB.preview.scrollbarSide:SetPoint("TOPLEFT", GCB.preview, "BOTTOMLEFT", 0, 5)
			GCB.preview.scrollbarSide:SetPoint("TOPRIGHT", GCB.preview, "BOTTOMRIGHT", 0, 5)
			GCB.preview.scrollbarSide:SetThickness(15)
			GCB.preview.scrollbarSide:SetRange(1,1)
			GCB.preview.scrollbarSide.Event.ScrollbarChange = function()
				local posUp = math.floor(GCB.preview.scrollbarUp:GetPosition())-1
				local posSide = math.floor(GCB.preview.scrollbarSide:GetPosition())-1
				local rtext = GCB.layout.Rows.value:GetText()
				GCB.preview.view:SetPoint("TOPLEFT", GCB.preview, "TOPLEFT", -(posSide*121), -(posUp*20))
				for cell,data in pairs(GCB.preview.view:GetChildren()) do
					if cell.row > posUp and cell.row <= posUp+6 and cell.row <= toNum(rtext) then
						if cell.column > posSide and cell.column <= posSide+4 then
							cell:SetVisible(true)
						else
							cell:SetVisible(false)
						end
					else
						cell:SetVisible(false)
					end
				end
			end
		
		previewLastRow = GCB.preview.view
	
		for pCol = 1, 20, 1 do
			for pRow = 1, 20, 1 do
				local name = "cell_" .. pRow .. "_" .. pCol
				local cell = UI.CreateFrame("Frame", name, GCB.preview.view)
					if pCol == 1 then
						if pRow == 1 then
							cell:SetPoint("TOPLEFT", GCB.preview.view, "TOPLEFT")
						else
							cell:SetPoint("TOPLEFT", previewLastRow, "BOTTOMLEFT")
						end
					elseif pCol > 1 then
						if pRow == 1 then
							cell:SetPoint("TOPLEFT", GCB.preview.view, "TOPLEFT", (121*(pCol-1)), 0)
						else
							cell:SetPoint("TOPLEFT", previewLastRow, "BOTTOMLEFT")
						end
					end
					cell.row = pRow
					cell.column = pCol
					cell.name = name
					cell:SetHeight(20)
					cell:SetWidth(121)
					cell:SetBackgroundColor(1,1,1,0)
					cell:SetLayer(10)
					cell.Event.MouseIn = function() cell:SetBackgroundColor(1,1,1,1) end
					cell.Event.MouseOut = function() cell:SetBackgroundColor(1,1,1,0) end
					function cell.Event.LeftDown()
						if cell.text:GetText() ~= "" then
							mouseFrame.text:SetText(cell.ltext)
							mouseFrame:SetVisible(true)
							mouseFrame.cname = cell.cname
							mouseFrame.iconName = cell.iconName
							if cell.cname == "credit" then
								mouseFrame.icon:SetTexture(AddonId, cell.iconName)
							else
								mouseFrame.icon:SetTexture("Rift", cell.iconName)
							end
							
							local mouse = Inspect.Mouse()
								mouseFrame:SetPoint("CENTER", WT.Context, "CENTER", mouse.x-18, mouse.y-18)
						end
					end
					function cell.Event.LeftUp()
						mouseFrame:SetVisible(false)
						if mouseFrame.text:GetText() ~= "" then
							cell.text:SetText(mouseFrame.text:GetText())
							cell.text:SetVisible(true)
							cell.back:SetBackgroundColor(0,0,0,1)
							cell.cname = mouseFrame.cname
							cell.ltext = mouseFrame.text:GetText()
							cell.iconName = mouseFrame.iconName
							cell.icon:SetVisible(true)
							if mouseFrame.iconName then
								if mouseFrame.cname == "credit" then
									cell.icon:SetTexture(AddonId, mouseFrame.iconName)
								else
									cell.icon:SetTexture("Rift", mouseFrame.iconName)
								end
							else
								if cell.cname == "credit" then
									cell.icon:SetTexture(AddonId, cell.iconName)
								else
									cell.icon:SetTexture("Rift", cell.iconName)
								end
							end
							mouseFrame.text:SetText("")
							mouseFrame.cname = nil
							mouseFrame.iconName = nil
						end
					end
					function cell.Event.LeftUpoutside()
						mouseFrame:SetVisible(false)
						cell.text:SetText("")
						cell.iconName = nil
						cell.icon:SetVisible(false)
						cell.back:SetBackgroundColor(0.5,0.5,0.5,1)
						cell.text:SetFontColor(1,1,1,1)
						cell.text:SetVisible(true)
						if cell.cname then
							cell.cname = nil
						end
						if cell.ltext then
							cell.ltext = nil
							mouseFrame.ltext = nil
						end
						if GCB.cellConfig and GCB.cellConfig:GetVisible() then
							GCB.cellConfig:SetVisible(false)
						end
					end
					function cell.Event.RightClick()
						if cell.text:GetText() ~= "" then
							GCB:PreviewCellConfig(cell)
						end
					end
			
				cell.back = UI.CreateFrame("Frame", name .. "_back", cell)
					cell.back:SetPoint("TOPLEFT", cell, "TOPLEFT", 2, 2)
					cell.back:SetPoint("BOTTOMRIGHT", cell, "BOTTOMRIGHT", -2, -2)
					cell.back:SetBackgroundColor(0.5,0.5,0.5,1)
					cell.back:SetVisible(true)
					cell.back:SetLayer(20)
					
				cell.icon = UI.CreateFrame("Texture", name .. "_icon", cell)
					cell.icon:SetPoint("CENTERLEFT", cell.back, "CENTERLEFT", 2, 0)
					cell.icon:SetHeight(16)
					cell.icon:SetWidth(16)
					cell.icon:SetVisible(false)
					cell.icon:SetLayer(30)
		
				cell.text = UI.CreateFrame("Text", name .. "_text", cell)
					cell.text:SetPoint("CENTERLEFT", cell.icon, "CENTERRIGHT", 2, 0)
					cell.text:SetWidth(cell.back:GetWidth()-20)
					cell.text:SetFontColor(1,1,1,1)
					cell.text:SetFontSize(14)
					cell.text:SetVisible(false)
					cell.text:SetLayer(30)
			
				if pCol == 1 and pRow == 1 then
					cell:SetVisible(true)
				else
					cell:SetVisible(false)
				end
				previewLastRow = cell
			end
		end
		
	GCB.reUpdate = false
	
	function previewUpdate(option, value)
	
		local posUp = math.floor(GCB.preview.scrollbarUp:GetPosition())
		local posSide = math.floor(GCB.preview.scrollbarSide:GetPosition())
		local ctext = GCB.layout.Columns.value:GetText()
		local rtext = GCB.layout.Rows.value:GetText()
		local upMin, upMax = GCB.preview.scrollbarUp:GetRange()
		local sideMin, sideMax = GCB.preview.scrollbarSide:GetRange()
		local nValue = toNum(value)
		
		
		if option == "row" and nValue < upMax+5 and not GCB.reUpdate then
			GCB.reUpdate = true
		elseif option == "column" and nValue < sideMax+3 and not GCB.reUpdate then
			GCB.reUpdate = true
		else
			GCB.reUpdate = false
		end
		
		if option == "row" and nValue > 5 then
			GCB.preview.scrollbarUp:SetRange(1,math.abs(nValue-5))
		elseif option == "row" then
			GCB.preview.scrollbarUp:SetRange(1,1)
		end
		
		if option == "column" and nValue > 3 then
			GCB.preview.scrollbarSide:SetRange(1,math.abs(nValue-3))
		elseif option == "column" then
			GCB.preview.scrollbarSide:SetRange(1,1)
		end
		
		function clearCell(cell)
			cell.text:SetText("")
			cell.icon:SetVisible(false)
			cell.back:SetBackgroundColor(0.5,0.5,0.5,1)
			cell.text:SetFontColor(1,1,1,1)
			cell.text:SetVisible(true)
			if cell.iconName then
				cell.iconName = nil
			end
			if cell.cname then
				cell.cname = nil
			end
			if cell.ltext then
				cell.ltext = nil
			end
			if GCB.cellConfig and GCB.cellConfig:GetVisible() then
				GCB.cellConfig:SetVisible(false)
			end
		end
		
		for cell, data in pairs(GCB.preview.view:GetChildren()) do
			if option == "row" and cell.row <= nValue and cell.column <= toNum(ctext) then
				if cell.row > posUp+5 then
					cell:SetVisible(false)
					if cell.row-5 > upMax then
						upMax = cell.row-5
					end
				elseif cell.row < posUp then
					cell:SetVisible(false)
				elseif cell.column > posSide+3 or cell.column < posSide then
					cell:SetVisible(false)
				else
					cell:SetVisible(true)
				end
				
				if cell.row > nValue and cell.column > toNum(ctext) then
					clearCell(cell)
				end
			elseif option == "column" and cell.column <= nValue and cell.row <= toNum(rtext) then
				if cell.column > posSide+3 then
					cell:SetVisible(false)
					if cell.column-3 > sideMax then
						sideMax = cell.column-3
					end
				elseif cell.column < posSide then
					cell:SetVisible(false)
				elseif cell.row > posUp+5 or cell.row < posUp then
					cell:SetVisible(false)
				else
					cell:SetVisible(true)
				end
				
				if cell.column > nValue and cell.row > toNum(rtext) then
					clearCell(cell)
				end
			else
				cell:SetVisible(false)
				if option == "row" and upMax > nValue-5 then
					if posUp > nValue-5 and nValue-5 > 0 then
						GCB.preview.scrollbarUp:SetPosition(nValue-5)
					elseif nValue-5 <= 0 then
						GCB.preview.scrollbarUp:SetPosition(1)
					end
				elseif option == "column" and sideMax > nValue-3 then
					if posSide > nValue-3 and nValue-3 > 0 then
						GCB.preview.scrollbarSide:SetPosition(nValue-3)
					elseif nValue-3 <= 0 then
						GCB.preview.scrollbarSide:SetPosition(1)
					end
				end
				if not cell:GetVisible() and cell.icon:GetVisible() then
					clearCell(cell)
				end
			end
		end
		
		if GCB.reUpdate then
			previewUpdate(option, value)
		end
	end
end

local function GetConfiguration()

	local configTable = {}
	
	for idx = 1, 20, 1 do
		table.insert(configTable, { {},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{} } )
	end
	for cell, data in pairs(GCB.preview.view:GetChildren()) do
		local bgr,bgg,bgb = cell.back:GetBackgroundColor()
		local bga = cell.alpha or 0
		local lblr,lblg,lblb = cell.text:GetFontColor()
		local statr,statg,statb
		if cell.statr and cell.statg and cell.statb then
			statr = cell.statr or 1
			statg = cell.statg or 1
			statb = cell.statb or 1
		else
			statr = 1
			statg = 1
			statb = 1
		end
		if cell.cname then
			configTable[cell.column][cell.row] = { name = cell.cname, text = cell.text:GetText(), icon = cell.iconName, Colors = { Back = {bgr,bgg,bgb,bga}, Label = {lblr,lblg,lblb}, Stat = {statr,statg,statb}} }
		end
	end
	
	configTable.rowText = GCB.layout.Rows.value:GetText()
	configTable.columnText = GCB.layout.Columns.value:GetText()
	configTable.tooltip = GCB.tooltip.label.check:GetChecked()
	
	return configTable
	
end

local function SetConfiguration(config)

	Command.System.Watchdog.Quiet()

	GCB.layout.Rows.value:SetText(config.rowText)
	previewUpdate("row", config.rowText)
	GCB.layout.Columns.value:SetText(config.columnText)
	previewUpdate("column", config.columnText)
	
	if config.tooltip then
		GCB.tooltip.label.check:SetChecked(config.tooltip)
	end

	for cell, data in pairs(GCB.preview.view:GetChildren()) do
		if cell.row <= toNum(config.rowText) and cell.column <= toNum(config.columnText) then
			local cellData = config[cell.column][cell.row]
			if cellData.Colors then
				cell.back:SetBackgroundColor(cellData.Colors.Back[1],cellData.Colors.Back[2],cellData.Colors.Back[3],1)
				cell.text:SetFontColor(cellData.Colors.Label[1],cellData.Colors.Label[2],cellData.Colors.Label[3],1)
				cell.statr = cellData.Colors.Stat[1]
				cell.statg = cellData.Colors.Stat[2]
				cell.statb = cellData.Colors.Stat[3]
				cell.alpha = cellData.Colors.Back[4]
			end
			if cellData.name then
				cell.text:SetText(cellData.text)
				cell.text:SetVisible(true)
				if cellData.name == "credit" then
					cell.icon:SetTexture(AddonId, cellData.icon)
				else
					cell.icon:SetTexture("Rift", cellData.icon)
				end
				cell.icon:SetVisible(true)
				cell.ltext = cellData.text
				cell.iconName = cellData.icon
				cell.cname = cellData.name
			end
		end
	end
end

WT.Gadget.RegisterFactory("CurrencyBar",
	{
		name="Currency Bar",
		description="Displays Player Currency",
		author="Noshei",
		version="1.2.0",
		iconTexAddon="Rift",
		iconTexFile="target_portrait_LootPinata.png.dds",
		["Create"] = Create,
		["ConfigDialog"] = ConfigDialog,
		["GetConfiguration"] = GetConfiguration, 
		["SetConfiguration"] = SetConfiguration, 
		["Reconfigure"] = Reconfigure,
	})
	
	
table.insert(Event.Mouse.Move,				{ mouseUpdate, AddonId, AddonId .. "_mouseFrame.Update" })
table.insert(Event.Currency,				{ currencyUpdate, AddonId, AddonId .. "_currencyUpdate" })